SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='DAILY_ATTENDANCE_MISSED_BY_FACULTY_RCPNT');
UPDATE `sql_dtprovider` SET `sqlQuery`='SELECT \n    T1.id AS ID,\n	DATE_FORMAT(T1.sessionDate, \'%d-%m-%Y\') AS SESSION_DATE,\n    T2.courseVariantDescription AS COURSE_VARIANT_DESCRIPTION,\n    T3.displayName AS ACADEMY_NAME,\n    T5.firstName AS FIRST_NAME,\n    T5.lastName AS LAST_NAME,\n	T5.emailId AS EMAIL_ID,\n    T5.mobileNumber AS MOBILE_NO,\n    T5.mobileCountryCode AS MOBILE_CODE,\n    T6.salutationName AS SALUTATION_NAME,\n    DATE_FORMAT(T1.slotFrom, \'%h:%i %p\') AS SLOT_FROM,\n    DATE_FORMAT(T1.slotTo, \'%h:%i %p\') AS SLOT_TO\nFROM\n    course_coverage_plan T1\n        LEFT JOIN\n    course_variants T2 ON T2.id = T1.courseVariantId\n        LEFT JOIN\n    academy_location T3 ON T3.id = T1.academyLocationId\n        LEFT JOIN\n    staffs T4 ON T4.userId = T1.facultyId\n        LEFT JOIN\n    persons T5 ON T5.id = T4.personId\n    LEFT join\n    salutations T6 ON T6.id = T5.salutationId\n    \nWHERE\n    T1.id IN (namedParams)', `jsonString`='{\n \"id\": 1,\n    \"searchResultViewColumns\": [\n        {\n            \"id\": 1,\n            \"value\": \"id\",\n            \"resultKey\": \"ID\",\n            \"displayCode\": \"\",\n            \"displayOrder\": 0\n        },        \n        {\n            \"id\": 2,\n            \"value\": \"firstName\",\n            \"resultKey\": \"FIRST_NAME\",\n            \"displayCode\": \"\",\n            \"displayOrder\": 1\n        },       \n        {\n            \"id\": 3,\n            \"value\": \"lastName\",\n            \"resultKey\": \"LAST_NAME\",\n            \"displayCode\": \"\",\n            \"displayOrder\": 2\n        },\n        {\n            \"id\": 4,\n            \"value\": \"sessionDate\",\n            \"resultKey\": \"SESSION_DATE\",\n            \"displayCode\": \"\",\n            \"displayOrder\": 3\n        },\n		{\n            \"id\": 5,\n            \"value\": \"courseVariantDescription\",\n            \"resultKey\": \"COURSE_VARIANT_DESCRIPTION\",\n            \"displayCode\": \"\",\n            \"displayOrder\": 4\n        },\n		{\n            \"id\": 6,\n            \"value\": \"displayName\",\n            \"resultKey\": \"ACADEMY_NAME\",\n            \"displayCode\": \"\",\n            \"displayOrder\": 5\n        },\n		{\n            \"id\": 7,\n            \"value\": \"SLOT_FROM\",\n            \"resultKey\": \"SLOT_FROM\",\n            \"displayCode\": \"\",\n            \"displayOrder\": 6\n        },\n		{\n            \"id\": 8,\n            \"value\": \"SLOT_TO\",\n            \"resultKey\": \"SLOT_TO\",\n            \"displayCode\": \"\",\n            \"displayOrder\": 7\n        },\n		{\n            \"id\": 9,\n            \"value\": \"salutationName\",\n            \"resultKey\": \"SALUTATION_NAME\",\n            \"displayCode\": \"\",\n            \"displayOrder\": 8\n        }\n    ]}' WHERE `dataProviderId`=@dtproviderId;

